/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.EmailConfigPanelBean;
import com.ibm.hwmca.base.ntfy.MainPanelBean;
import com.ibm.hwmca.base.ntfy.NotificationAbstractTasklet;
import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.ntfy.DuplicateNameException;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NotificationTasklet
extends NotificationAbstractTasklet {
    private static final String TRACE_MASKT = "XNTYTSKT";
    private static final String TRACE_MASKF = "XNTYTSKF";
    private static final String TRACE_MASKD = "XNTYTSKD";
    private static final String MAIN_PANEL_MOUNT_POINT = "MP";

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> init()");
        super.init();
        this.errorId = (short)-32766;
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "<> destroy()");
        super.destroy();
        this.errorId = (short)-32765;
        try {
            NotificationService.saveData();
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, ioe);
        }
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> NotificationTasklet.service()");
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.serviceInitial(request, response);
        } else if (request.isCanceled() || request.isDisposed() || command.equals("") || command.equals("CANCEL")) {
            this.serviceDisposed(request, response);
        } else if (request.getData("CommandSource") != null) {
            String source = (String)request.getData("CommandSource");
            if (source.equals("MainPanel")) {
                this.serviceMainPanel(request, response);
            } else if (source.equals("EmailConfigPanel")) {
                this.serviceEmailConfigPanel(request, response);
            } else {
                response.error(new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.error.unknownsource", new String[]{source}), "NotificationTasklet");
            }
        } else {
            response.error(new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.error.unknownsource", new String[]{"null"}), "NotificationTasklet");
        }
    }

    private void serviceInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> servicing an initial request");
        if (NotificationService.getManager().getSinkClassPropertyMap() == null || NotificationService.getManager().getSinkClassPropertyMap().isEmpty()) {
            this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.task.name"), new MessageText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.error.nosinks", null), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
            new FrameworkLog(NotificationErrorIds._logInfo, -32738, new HException("No sinks found")).log(LogAttributes.INFO_LOG);
            response.terminate();
        } else if (NotificationService.getManager().getSourceClassPropertyMap() == null || NotificationService.getManager().getSourceClassPropertyMap().isEmpty()) {
            this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.task.name"), new MessageText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.error.nosources", null), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
            new FrameworkLog(NotificationErrorIds._logInfo, -32738, new HException("No sources found")).log(LogAttributes.INFO_LOG);
            response.terminate();
        } else {
            MainPanelBean bean = new MainPanelBean();
            bean.setBeanName("MainPanel");
            DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.ntfy.res.NotificationRes", "MainPanel", bean, null, null);
            DisplayAreaDescriptorDelegate delegate = new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.ntfy.SwitchingTasklet", null);
            delegate.setMountPoint(MAIN_PANEL_MOUNT_POINT);
            response.replace(frame, new DisplayAreaDescriptor[]{delegate});
        }
    }

    private void serviceMainPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceMainPanel");
        this.errorId = (short)-32757;
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (command.equals("AdvancedModeItem")) {
            Trace.trace(TRACE_MASKT, "<> Advanced Mode");
            try {
                NotificationService.getManager().getGlobalProperties().remove("advanced");
                NotificationService.getManager().getGlobalProperties().put("advanced", "true");
                response.noAction();
            }
            catch (DuplicateNameException dne) {
                this.duplicateMessage("advanced");
                response.noAction();
            }
        } else if (command.equals("SimpleModeItem")) {
            Trace.trace(TRACE_MASKT, "<> Simple Mode");
            try {
                NotificationService.getManager().getGlobalProperties().remove("advanced");
                NotificationService.getManager().getGlobalProperties().put("advanced", "false");
                response.noAction();
            }
            catch (DuplicateNameException dne) {
                this.duplicateMessage("advanced");
                response.noAction();
            }
        } else if (command.equals("ConfigButton")) {
            EmailConfigPanelBean bean = new EmailConfigPanelBean();
            bean.setBeanName("EmailConfigPanel");
            HashMap beanData = new HashMap();
            beanData.put("DataMapHost", NotificationService.getManager().getGlobalProperties().get("smtpserver"));
            beanData.put("DataMapPort", NotificationService.getManager().getGlobalProperties().get("smtpport"));
            beanData.put("DataMapWindowMinutes", NotificationService.getManager().getGlobalProperties().get("windowminutes"));
            bean.setData(beanData);
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EmailConfigPanel", bean);
        } else {
            this.unknownCommand(response, command);
        }
    }

    private void serviceEmailConfigPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceEmailConfigPanel");
        this.errorId = (short)-32761;
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (command.equals("OKButton")) {
            Map map = (Map)request.getData("TaskletDataMap");
            NotificationService.getManager().getGlobalProperties().remove("smtpserver");
            NotificationService.getManager().getGlobalProperties().remove("smtpport");
            NotificationService.getManager().getGlobalProperties().remove("windowminutes");
            NotificationService.getManager().getGlobalProperties().put("smtpserver", map.get("DataMapHost"));
            NotificationService.getManager().getGlobalProperties().put("smtpport", map.get("DataMapPort"));
            NotificationService.getManager().getGlobalProperties().put("windowminutes", map.get("DataMapWindowMinutes"));
            this.serviceDisposed(request, response);
        } else if (command.equals("CancelButton")) {
            this.serviceDisposed(request, response);
        } else {
            this.unknownCommand(response, command);
        }
    }
}

